/* -*- Mode:C++; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/**
 * NIST-developed software is provided by NIST as a public service. You may
 * use, copy and distribute copies of the software in any medium, provided that
 * you keep intact this entire notice. You may improve, modify and create
 * derivative works of the software or any portion of the software, and you may
 * copy and distribute such modifications or works. Modified works should carry
 * a notice stating that you changed the software and should note the date and
 * nature of any such change. Please explicitly acknowledge the National
 * Institute of Standards and Technology as the source of the software.
 *
 * NIST-developed software is expressly provided "AS IS." NIST MAKES NO
 * WARRANTY OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF
 * LAW, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST
 * NEITHER REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE
 * UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST
 * DOES NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE
 * SOFTWARE OR THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE
 * CORRECTNESS, ACCURACY, RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
 *
 * You are solely responsible for determining the appropriateness of using and
 * distributing the software and you assume all risks associated with its use,
 * including but not limited to the risks and costs of program errors,
 * compliance with applicable laws, damage to or loss of data, programs or
 * equipment, and the unavailability or interruption of operation. This
 * software is not intended to be used in any situation where a failure could
 * cause risk of injury or damage to property. The software developed by NIST
 * employees is not subject to copyright protection within the United States.
 */

#ifndef ORAN_CMM_NOOP_H
#define ORAN_CMM_NOOP_H

#include "oran-cmm.h"

namespace ns3
{

class OranCommand;

/**
 * \ingroup oran
 *
 * A Conflict Mitigation Module that does nothing. This implementation
 * is useful for the cases when we are not interested in having a
 * Conflict Mitigation Logic, as the Near-RT RIC must have a CMM instance
 * configured.
 */
class OranCmmNoop : public OranCmm
{
  public:
    /**
     * Gets the TypeId of the OranCmmNoop class.
     *
     * \return The TypeId.
     */
    static TypeId GetTypeId();
    /**
     * Creates an instance of the OranCmmNoop class.
     */
    OranCmmNoop();
    /**
     * The destructor of the OranCmmNoop class.
     */
    ~OranCmmNoop() override;
    /**
     * Prompts this Conflict Mitigation Module to execute its logic
     * and filter the input commands. This is a No Operation module,
     * so the input set of commands will be returned without filtering.
     *
     * \param inputCommands A map with the input commands generated by all the LMs.
     *
     * \return A vector with the commands filtered by this module.
     */
    std::vector<Ptr<OranCommand>> Filter(
        std::map<std::tuple<std::string, bool>, std::vector<Ptr<OranCommand>>> inputCommands)
        override;

  protected:
    void DoDispose() override;
}; // class OranCmmNoop

} // namespace ns3

#endif // ORAN_CMM_NOOP_H
